
#include <Wire.h> 
#include <LiquidCrystal_I2C.h>
LiquidCrystal_I2C lcd(0x27,20,4);  // set the LCD address to 0x27 for a 16 chars and 2 line display

// Anschlussbelegung Display

// Analog 4 = SDA Anzeige (Daten)
// Analog 5 = SCL Anzeige (Takt)

// Display -> I2C Modul +LCD 1602A 16x2 Blau Zeichen Display HD44780 LCD1602

// Anschlussbelegung Tasten
//Digital 2 -> schnell vor
//Digital 3 -> schnell rück
//Digital 4 -> langsam vor
//Digital 5 -> langsam rück
//Digital 6 -> Stellung merken
//Digital 7 -> zur gemerkten Stellung

// Motorausgänge: Digital 8-11
// Motor muss über Treiber angesteuert werden (5V Step Motor 4 Phasen Schrittmotor Treiberplatine Modul ULN2003 für Arduino)

//LED Anzeige (LED über Vorschaltwiderstand 500 Ohm)
// vor gespeichertem Wert -> Digital 12
// nach gespeichertem Wert -> Digital 13

// alle Schalter gegen Masse


// Übersetzung des Motors 1/64, 512 Schritte für eine Umdrehung 

//Namen für Ausgabe Motor
int aus1=8;int aus2=9;int aus3=10;int aus4=11; 

//Namen Lage zum gespeicherten Wert 
int vor_speicher=12;int nach_speicher=13;

int ausgabe_motor [8][8] ={{1,0,0,0,1,0,0,1},
                           {1,1,0,0,0,0,0,1},
                           {0,1,0,0,0,0,1,1},
                           {0,1,1,0,0,0,1,0},
                           {0,0,1,0,0,1,1,0},
                           {0,0,1,1,0,1,0,0},
                           {0,0,0,1,1,1,0,0},
                           {1,0,0,1,1,0,0,0},};


//Namen für Eingänge
int schalter_schnell_vor=2;int schalter_schnell_ruek=3;int schalter_langsam_vor=4;
int schalter_langsam_ruek=5;int schalter_merken=6;int schalter_home=7; 

//Variable
int zw=0;long stellung=0; long ver_stellung=0; long speicher=0; long ver_speicher=0; long maxwert=5120; int tempo=0; 
int schnell=2; int langsam=10;

//--------------------------------------------------------------------------------

void setup()
{
  lcd.init();                      // initialize the lcd 
  lcd.init();
  lcd.backlight();
  
lcd.setCursor(0,0);lcd.print("Stellung"); 
lcd.setCursor(9,0);lcd.print(stellung); 
lcd.setCursor(0,1);lcd.print("Speicher"); 
lcd.setCursor(9,1);lcd.print(speicher); 


// Motorausgänge  
pinMode (aus1,OUTPUT);pinMode (aus2,OUTPUT);pinMode (aus3,OUTPUT);pinMode (aus4,OUTPUT); 

// Lage zum gespeicherten Wert
pinMode (vor_speicher,OUTPUT);pinMode (nach_speicher,OUTPUT);

//Tasteneingänge
pinMode(schalter_schnell_vor,INPUT);pinMode(schalter_schnell_ruek,INPUT);
pinMode(schalter_langsam_vor,INPUT);pinMode(schalter_langsam_ruek,INPUT);
pinMode(schalter_merken,INPUT);pinMode(schalter_home,INPUT); 

//interner Pullup
digitalWrite (schalter_schnell_vor,HIGH);digitalWrite (schalter_schnell_ruek,HIGH);
digitalWrite (schalter_langsam_vor,HIGH);digitalWrite (schalter_langsam_ruek,HIGH);
digitalWrite (schalter_merken,HIGH);digitalWrite (schalter_home,HIGH); 
}

//-------------------------------------------------------------------------------------------------------------------

void loop() {
  
//lcd.setCursor(0,0);lcd.print("Stellung"); 
//lcd.setCursor(9,0);lcd.print(stellung);  
  
//Tastaturabfrage Bewegung
if(digitalRead(schalter_schnell_vor)==0){tempo=schnell;vor();}
if(digitalRead(schalter_schnell_ruek)==0){tempo=schnell;ruek();}
if(digitalRead(schalter_langsam_vor)==0){tempo=langsam;vor();ausgabe();} 
if(digitalRead(schalter_langsam_ruek)==0){tempo=langsam;ruek();ausgabe();}

//Tastaturabfrage Speicher  
if(digitalRead(schalter_merken)==0){speicher=stellung;}

//Tastaturabfrage Home
if(digitalRead(schalter_home)==0&&stellung<speicher)
 {tempo=schnell;lcd.setCursor(14,0);lcd.print("<-");  
 do{vor();}
 while(stellung!=speicher);
}
if(digitalRead(schalter_home)==0&&stellung>speicher)
 {tempo=schnell;lcd.setCursor(14,0);lcd.print("->"); 
 do{ruek();}
 while(stellung!=speicher);
}

//Tastaturabfrage Motor aus
if(digitalRead(schalter_schnell_vor)==1&&digitalRead(schalter_schnell_ruek)==1&&
digitalRead(schalter_langsam_vor)==1&&digitalRead(schalter_langsam_ruek)==1&&
digitalRead(schalter_home)==1)

//Motor aus; Ausgabe Daten
{delay(tempo);digitalWrite(aus1,0);digitalWrite(aus2,0);digitalWrite(aus3,0);digitalWrite(aus4,0);

if(stellung != ver_stellung || speicher != ver_speicher)
{ ausgabe(); }

ver_stellung=stellung; ver_speicher=speicher;


lcd.setCursor(14,0);lcd.print("  ");  
}


//Lage zum Speicher

if (stellung<=speicher){digitalWrite (vor_speicher,1);}
else {digitalWrite (vor_speicher,0);}

if (stellung>=speicher){digitalWrite (nach_speicher,1);}
else {digitalWrite (nach_speicher,0);}

}

// -------------------------- Unterprogramme ---------------------------------------------------
void vor(){ 
if (stellung<maxwert){
 zw=0;
 do{  
   digitalWrite(aus1,ausgabe_motor[zw][0]);digitalWrite(aus2,ausgabe_motor[zw][1]);
   digitalWrite(aus3,ausgabe_motor[zw][2]);digitalWrite(aus4,ausgabe_motor[zw][3]);
   delay(tempo);
   zw++;
 }while(zw<8);
 stellung++;
}}

void ruek(){ 
if (stellung>0){ 
 zw=0;
 do{  
   digitalWrite(aus1,ausgabe_motor[zw][4]);digitalWrite(aus2,ausgabe_motor[zw][5]);
   digitalWrite(aus3,ausgabe_motor[zw][6]);digitalWrite(aus4,ausgabe_motor[zw][7]);
   delay(tempo);
   zw++;
 }while(zw<8);
 stellung--;
}}

void ausgabe(){
lcd.setCursor(0,0);lcd.print("Stellung        "); lcd.setCursor(9,0);lcd.print(stellung); 
lcd.setCursor(0,1);lcd.print("Speicher        "); lcd.setCursor(9,1);lcd.print(speicher); 
}
  

//HUK 2018
